#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Dragon Skin By Rik(Voronoi)Mod01.fsh  by  rikr   
//https://www.shadertoy.com/view/XffcDB
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Dragon Skin (Voronoi Test)
// By Rik Riesmeijer, 2024 - No Rights Reserved.

// License: CC0 1.0 Universal - Commercial Use Allowed.
// Copyright Has Been Released To The Public Domain. 
// More information at: CreativeCommons.org/publicdomain.

//void mainImage(out vec4 c, in vec2 v) {
#define c fragColor
#define v fragCoord
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Making it move.
    v += 2e2 + iTime * 2e2;
    
    // Generate a random looking 2d grid origin.
    #define r(e) (94587u * e ^ e.yx)
    #define o vec2(r(r(r(uvec2(ip + g))))) / vec2(-1u)
    
    // Setting up variables to track the minimum distance in the grid.
    vec2 d, g, r, ming, minr, mind = vec2(1e3);
    
    // Get the integer part and fractional part of the UV coordinate.
    vec2 ip = floor(v /= 1e2), fp = fract(v);
    
    // Expression of the grid position.
    #define g vec2(float(i % 3 - 1), float(i / 3 - 1))
    
    // Minimum distance for the 3x3 grid.
    for(int i = 0; i < 9; i++)
        mind.x = ((d.x = length(r = g + o - fp)) > mind.x)?
            mind.x : length(minr = (ming = g) + o - fp);

    // Display the colors.
    fragColor = vec4(smoothstep(0.0, 1.0, minr).yx, length(minr), 1);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

